<?php
if ( !class_exists('Royal_Magazine_Dashboard_Notice') ):

    class Royal_Magazine_Dashboard_Notice
    {
        function __construct()
        {	
            global $pagenow;

        	if( $this->royal_magazine_show_hide_notice() ){

                add_action( 'admin_notices',array( $this,'royal_magazine_admin_notice' ) );
                
	        }
	        add_action( 'wp_ajax_royal_magazine_notice_dismiss', array( $this, 'royal_magazine_notice_dismiss' ) );
			add_action( 'switch_theme', array( $this, 'royal_magazine_notice_clear_cache' ) );

            if( isset( $_GET['page'] ) && $_GET['page'] == 'royal-magazine-about' ){

                add_action('in_admin_header', array( $this,'royal_magazine_hide_all_admin_notice' ),1000 );

            }

        }

        public function royal_magazine_hide_all_admin_notice(){

            remove_all_actions('admin_notices');
            remove_all_actions('all_admin_notices');

        }
        
        public static function royal_magazine_show_hide_notice( $status = false ){

            if( $status ){

                if( (class_exists( 'Booster_Extension_Class' ) ) || get_option('twp_royal_magazine_admin_notice') ){

                    return false;

                }else{

                    return true;

                }

            }

            // Check If current Page 
            if ( isset( $_GET['page'] ) && $_GET['page'] == 'royal-magazine-about'  ) {
                return false;
            }

        	// Hide if dismiss notice
        	if( get_option('twp_royal_magazine_admin_notice') ){
				return false;
			}
        	// Hide if all plugin active
        	if ( class_exists( 'Booster_Extension_Class' ) && class_exists( 'Social_Share_With_Floating_Bar' ) && class_exists( 'Demo_Import_Kit_Class' ) && class_exists( 'Themeinwp_Import_Companion' ) ) {
				return false;
			}
			// Hide On TGMPA pages
			if ( ! empty( $_GET['tgmpa-nonce'] ) ) {
				return false;
			}
			// Hide if user can't access
        	if ( current_user_can( 'manage_options' ) ) {
				return true;
			}
			
        }

        // Define Global Value
        public static function royal_magazine_admin_notice(){

            $theme_info      = wp_get_theme();
            $theme_name            = $theme_info->__get( 'Name' ); ?>

            <div class="updated notice is-dismissible twp-royal-magazine-notice">

                <h3><?php esc_html_e('Quick Setup','royal-magazine'); ?></h3>

                <p><strong><?php printf( __( '%1$s is now installed and ready to use. Are you looking for a better experience to set up your site?', 'royal-magazine' ), esc_html( $theme_name ) ); ?></strong></p>

                <small><?php esc_html_e("We've prepared a unique onboarding process through our",'royal-magazine'); ?> <a href="<?php echo esc_url( admin_url().'themes.php?page='.get_template().'-about') ?>"><?php esc_html_e('Getting started','royal-magazine'); ?></a> <?php esc_html_e("page. It helps you get started and configure your upcoming website with ease. Let's make it shine!",'royal-magazine'); ?></small>

                <p>
                    <a target="_blank" class="button button-primary button-primary-upgrade" href="<?php echo esc_url( 'https://www.themeinwp.com/theme/royal-magazine-pro/' ); ?>">
                        <span class="dashicons dashicons-thumbs-up"></span>
                        <span><?php esc_html_e('Upgrade to Pro','royal-magazine'); ?></span>
                    </a>

                    <a class="button button-secondary twp-install-active" href="javascript:void(0)">
                        <span class="dashicons dashicons-admin-plugins"></span>
                        <span><?php esc_html_e('Install and activate recommended plugins','royal-magazine'); ?></span>
                    </a>

                    <span class="quick-loader-wrapper"><span class="quick-loader"></span></span>

                    <a target="_blank" class="button button-secondary" href="<?php echo esc_url( 'https://demo.themeinwp.com/royal-magazine/' ); ?>">
                        <span class="dashicons dashicons-welcome-view-site"></span>
                        <span><?php esc_html_e('View Demo','royal-magazine'); ?></span>
                    </a>

                    <a target="_blank" class="button button-primary" href="<?php echo esc_url('https://wordpress.org/support/theme/royal-magazine/reviews/?filter=5'); ?>">
                        <span class="dashicons dashicons-star-filled"></span>
                        <span class="dashicons dashicons-star-filled"></span>
                        <span class="dashicons dashicons-star-filled"></span>
                        <span class="dashicons dashicons-star-filled"></span>
                        <span class="dashicons dashicons-star-filled"></span>
                        <span><?php esc_html_e('Leave a review', 'royal-magazine'); ?></span>
                    </a>

                    <a class="btn-dismiss twp-custom-setup" href="javascript:void(0)"><?php esc_html_e('Dismiss this notice.','royal-magazine'); ?></a>

                </p>

            </div>

        <?php
        }

        public function royal_magazine_notice_dismiss(){

        	if ( isset( $_POST[ '_wpnonce' ] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST[ '_wpnonce' ] ) ), 'royal_magazine_ajax_nonce' ) ) {

	        	update_option('twp_royal_magazine_admin_notice','hide');

	        }

            die();

        }

        public function royal_magazine_notice_clear_cache(){

        	update_option('twp_royal_magazine_admin_notice','');

        }

    }
    new Royal_Magazine_Dashboard_Notice();
endif;