<?php
/**
* About Rencer Content.
*
* @package Royal Magazine
*/


$base_url = home_url();

$royal_magazine_panels_sections = array(

    'theme_general_settings' => array(

        'title' => esc_html__('General Settings','royal-magazine'),
        'sections' => array(

            array(
                'title' => esc_html__('Logo & Site Identity','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bcontrol%5D=custom_logo'),
                'icon'  => 'dashicons-format-image',
            ),
            array(
                'title' => esc_html__('Header Media','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=header_image'),
                'icon'  => 'dashicons-desktop',
            ),
            array(
                'title' => esc_html__('Background Image','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=background_image'),
                'icon'  => 'dashicons-desktop',
            ),
            array(
                'title' => esc_html__('Menu Settings','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bpanel%5D=nav_menus'),
                'icon'  => 'dashicons-menu',
            ),

        ),

    ),
    'theme_front_page_section' => array(

        'title' => esc_html__('Home/Front Page Settings','royal-magazine'),
        'sections' => array(

            array(
                'title' => esc_html__('Header Section','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=top_section_settings'),
                'icon'  => 'dashicons-admin-generic',
            ),
            array(
                'title' => esc_html__('Slider Section','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=slider_section_settings'),
                'icon'  => 'dashicons-admin-generic',
            ),

        ),

    ),
    'theme_widgets_section' => array(

        'title' => esc_html__('Widgets','royal-magazine'),
        'sections' => array(

            array(
                'title' => esc_html__('Add Home Widgets','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/widgets.php'),
                'icon'  => 'dashicons-admin-generic',
            ),

        ),

    ),
    'theme_option_panel' => array(

        'title' => esc_html__('Theme Options','royal-magazine'),
        'sections' => array(

            array(
                'title' => esc_html__('Header Settings','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=top_section_settings'),
                'icon'  => 'dashicons-admin-generic',
            ),
            array(
                'title' => esc_html__('Layout Management','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=theme_option_section_settings'),
                'icon'  => 'dashicons-admin-generic',
            ),
            array(
                'title' => esc_html__('Pagination Options','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=pagination_section'),
                'icon'  => 'dashicons-admin-generic',
            ),
            array(
                'title' => esc_html__('Breadcrumb Options','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=breadcrumb_section'),
                'icon'  => 'dashicons-admin-generic',
            ),
            array(
                'title' => esc_html__('Single Posts','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=single_post_setting'),
                'icon'  => 'dashicons-admin-generic',
            ),
            array(
                'title' => esc_html__('Preloader Options','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=preloader_section'),
                'icon'  => 'dashicons-admin-generic',
            ),
            array(
                'title' => esc_html__('Footer Options','royal-magazine'),
                'url'   => esc_url( $base_url.'/wp-admin/customize.php?autofocus%5Bsection%5D=footer_section'),
                'icon'  => 'dashicons-admin-generic',
            ),

        ),

    ),

);

include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
$rec_plugins =Royal_Magazine_Getting_started::royal_magazine_recommended_plugins();
$theme_version = wp_get_theme()->get( 'Version' );
$theme_info = wp_get_theme();
$theme_name = $theme_info->__get('Name');
?>
<div class="twp-about-main">

    <div class="about-page-header">
        <div class="about-wrapper">
            <div class="about-wrapper-inner">
                <div class="about-header-left">
                    <h1 class="about-theme-title">
                        <a href="<?php echo esc_url( 'https://www.themeinwp.com/theme/royal-magazine' ); ?>">
                            <img src="<?php echo esc_url( get_template_directory_uri().'/images/royal-magazine-logo.png' ); ?>" class="about-theme-logo">
                            <span class="theme-version"><?php echo esc_html( $theme_version ); ?></span>
                        </a>
                    </h1>
                </div>
                <div class="about-header-right">
                    <p><?php esc_html_e('Eye-catching, Lightweight, and Highly Customizable WordPress Theme','royal-magazine'); ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="about-page-content">
        <div class="about-wrapper">
            <div class="about-wrapper-inner">

                <div class="about-content-left">

                    <?php
                    foreach( $royal_magazine_panels_sections as $panels ){ ?>

                        <div class="about-content-panel">

                            <?php if( isset( $panels['title'] ) && $panels['title'] ){ ?>

                                <h2 class="about-panel-title"><?php echo esc_html( $panels['title'] );  ?></h2>

                            <?php } ?>
                            <div class="about-panel-items about-panel-2-columns">
                            <?php

                            if( isset( $panels['sections'] ) && $panels['sections'] ){

                                foreach( $panels['sections'] as $section ){ ?>


                                    <div class="about-items-wrap">
                                        <?php if( isset( $section['icon'] ) && $section['icon'] ){ ?>
                                            <span class="about-items-icon dashicons <?php echo esc_attr( $section['icon'] ); ?>"></span>
                                        <?php } ?>

                                        <?php if( isset( $section['title'] ) && $section['title'] && isset( $section['url'] ) && $section['url'] ){ ?>
                                            <span class="about-items-title">
                                                <a href="<?php echo esc_url( $section['url'] ); ?>"><?php echo esc_html( $section['title'] ); ?></a>
                                            </span>
                                        <?php } ?>
                                    </div>


                            <?php }

                            } ?>
                            </div>
                        </div>

                    <?php } ?>

                    <div class="about-content-panel">

                        <h2 class="about-panel-title"><?php esc_html_e('Recommended Plugins','royal-magazine'); ?></h2>

                        <div class="about-panel-items about-panel-1-columns">

                            <?php foreach ($rec_plugins as $key => $plugin) {

                                $plugin_info = plugins_api(
                                    'plugin_information',
                                    array(
                                        'slug' => sanitize_key(wp_unslash($key)),
                                        'fields' => array(
                                            'sections' => false,
                                        ),
                                    )
                                );

                                $plugin_status =Royal_Magazine_Getting_started::royal_magazine_plugin_status($plugin['class'], $key, $plugin['PluginFile']); ?>

                                <div id="<?php echo 'royal-magazine-' . esc_attr($key); ?>" class="about-items-wrap">
                                    <div class="theme-recommended-plugin <?php if ($plugin_status['status'] == 'active') { echo 'recommended-plugin-active'; } ?>">

                                        <?php if (isset($plugin_info->name)) { ?>
                                            <a href="javascript:void(0)"><?php echo esc_html($plugin_info->name); ?></a>
                                        <?php } ?>

                                        <?php if (isset($plugin_status['status']) && isset($plugin_status['string'])) { ?>

                                            <a class="recommended-plugin-status <?php echo 'twp-plugin-' . esc_attr($plugin_status['status']); ?>"
                                               plugin-status="<?php echo esc_attr($plugin_status['status']); ?>"
                                               plugin-file="<?php echo esc_attr($plugin['PluginFile']); ?>"
                                               plugin-folder="<?php echo esc_attr($key); ?>"
                                               plugin-slug="<?php echo esc_attr($key); ?>"
                                               plugin-class="<?php echo esc_attr($plugin['class']); ?>"
                                               href="javascript:void(0)"><?php echo esc_html($plugin_status['string']); ?></a>

                                        <?php } ?>

                                    </div>

                                </div>

                            <?php } ?>

                        </div>

                    </div>

                </div>

                <div class="about-content-right">

                    <div class="about-content-panel">
                        <h2 class="about-panel-title"><span class="dashicons dashicons-sos"></span> <?php esc_html_e('Looking for help?','royal-magazine'); ?></h2>
                        <div class="about-content-info">
                            <p><?php esc_html_e('We have some resources available to help you in the right direction.','royal-magazine'); ?></p>
                            <ul>
                                <li>
                                    <a href="<?php echo esc_url( 'https://www.themeinwp.com/support/' ); ?>" target="_blank" rel="noopener"><?php esc_html_e('Create a Ticket','royal-magazine'); ?> &#187;</a>
                                </li>
                                <li>
                                    <a href="<?php echo esc_url( 'https://www.themeinwp.com/knowledgebase/' ); ?>" target="_blank" rel="noopener"><?php esc_html_e('Knowledge Base','royal-magazine'); ?> &#187;</a>
                                </li>
                                <li>
                                    <a href="<?php echo esc_url( 'https://docs.themeinwp.com/docs/royal-magazine' ); ?>" target="_blank" rel="noopener"><?php esc_html_e('Theme Documentation','royal-magazine'); ?> &#187;</a>
                                </li>
                            </ul>
                            <p><?php esc_html_e('Behind every single customer support question stands a real person ready to fix the problem in real-time and guide you through.','royal-magazine'); ?></p>
                        </div>
                    </div>

                    <div class="about-content-panel about-content-panel-upgrade">
                        <h2 class="about-panel-title"><?php printf( __( 'Unlock all the Features with %1$s Pro', 'royal-magazine' ), esc_html( $theme_name ) ); ?></h2>
                        <div class="about-content-info">
                            <ul>
                                <li><span class="dashicons dashicons-yes"></span><?php esc_html_e('Color Options','royal-magazine'); ?></li>
                                <li><span class="dashicons dashicons-yes"></span><?php esc_html_e('800+ Font Families','royal-magazine'); ?></li>
                                <li><span class="dashicons dashicons-yes"></span><?php esc_html_e('More Custom Widgets','royal-magazine'); ?></li>
                                <li><span class="dashicons dashicons-yes"></span><?php esc_html_e('More Customizer controls','royal-magazine'); ?></li>
                                <li><span class="dashicons dashicons-yes"></span><?php esc_html_e('More page/post meta options','royal-magazine'); ?></li>
                                <li><span class="dashicons dashicons-yes"></span><?php esc_html_e('Webmaster Tools','royal-magazine'); ?></li>
                                <li><span class="dashicons dashicons-yes"></span><?php esc_html_e('Remove Footer Attribution (copyright)','royal-magazine'); ?></li>
                                <li><span class="dashicons dashicons-yes"></span><?php esc_html_e('VIP priority Support','royal-magazine'); ?></li>
                                <li></span><?php esc_html_e('+ much more stuff...','royal-magazine'); ?></li>
                            </ul>


                                <div class="about-footer-upgrade">
                                    <h4 class="footer-upgrade-title">
                                        <?php esc_html_e('Upgrade to Pro','royal-magazine'); ?>
                                    </h4>
                                    <div class="footer-upgrade-content">
                                        <div class="footer-upgrade-price">
                                            <?php esc_html_e('$59','royal-magazine'); ?>
                                        </div>
                                        <div class="footer-upgrade-link">
                                            <a target="_blank" class="button button-primary button-primary-upgrade" href="<?php echo esc_url( 'https://www.themeinwp.com/theme/royal-magazine-pro/' ); ?>"><?php esc_html_e('Upgrade to Pro','royal-magazine'); ?></a>
                                        </div>
                                    </div>
                                </div>

                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>

</div>